<?php

include("rs.php");

$matchkey = $_POST['matchkey'];


$matchTypeQuery = "SELECT `match` FROM `match` WHERE matchkey = ?";
$typeStmt = $conn->prepare($matchTypeQuery);
$typeStmt->bind_param("s", $matchkey);
$typeStmt->execute();
$typeResult = $typeStmt->get_result();

if ($typeResult->num_rows > 0) {
    $typeRow = $typeResult->fetch_assoc();
    $matchType = $typeRow['match'];

    if ($matchType == 'Match') {
        
        $sql = "SELECT `rc`, `name` FROM `participate` WHERE matchkey = ?";
        $stmt = $conn->prepare($sql);
        $stmt->bind_param("s", $matchkey);
        $stmt->execute();
        $result = $stmt->get_result();

        if ($result->num_rows > 0) {
            $participants = $result->fetch_all(MYSQLI_ASSOC);

            foreach ($participants as $participant) {
                $rc = $participant['rc'];

                
                $feeQuery = "SELECT `entryfees` FROM `match` WHERE matchkey = ?";
                $feeStmt = $conn->prepare($feeQuery);
                $feeStmt->bind_param("s", $matchkey);
                $feeStmt->execute();
                $feeResult = $feeStmt->get_result();

                if ($feeResult->num_rows > 0) {
                    $feeRow = $feeResult->fetch_assoc();
                    $joining_fee = $feeRow['entryfees'];

                    
                    $updateBalance = "UPDATE `users` SET `b` = `b` + ? WHERE `rc` = ?";
                    $balanceStmt = $conn->prepare($updateBalance);
                    $balanceStmt->bind_param("ds", $joining_fee, $rc);
                    $balanceStmt->execute();
                }
            }
        }
    }

    
    $deleteMatch = "DELETE FROM `match` WHERE matchkey = ?";
    $deleteStmt = $conn->prepare($deleteMatch);
    $deleteStmt->bind_param("s", $matchkey);

    if ($deleteStmt->execute()) {
        echo json_encode(["status" => "success"]);
    } else {
        echo json_encode(["status" => "error", "message" => $conn->error]);
    }
} else {
    echo json_encode(["status" => "error", "message" => "Match not found"]);
}

$conn->close();

?>